---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-画像変換操作（Image Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15 30FPSパフォーマンス要件**：具体的な性能数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
- E-01: `tensorflow/core/ops/image_ops.cc` 全体（1224行）
- E-02: `tensorflow/core/ops/image_ops.cc` 274-282行目 ResizeArea
- E-03: `tensorflow/core/ops/image_ops.cc` 310-319行目 ResizeBilinear
- E-04: `tensorflow/core/ops/image_ops.cc` 463-471行目 DecodeImage
- E-05: `tensorflow/core/ops/image_ops.cc` 981-1005行目 NonMaxSuppression
- E-06: `tensorflow/core/ops/image_ops.cc` 30-66行目 SetOutputToSizedImage
- E-07: `tensorflow/core/ops/image_ops.cc` 155-176行目 NMSShapeFn
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.1-7,9,10のマッピング
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` No.52行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リサイズ系OpはBilinear/Bicubic/NearestNeighbor/Area補間を提供 | E-01, E-02, E-03 | ○ |
| C-02 | デコード系OpはJPEG/PNG/BMP/GIF/WebP/JXL形式に対応 | E-01, E-04 | ○ |
| C-03 | NMS V1〜V5およびCombinedNMSが定義されている | E-05, E-07 | ○ |
| C-04 | SetOutputToSizedImageは出力を[batch, height, width, channels]形状に設定 | E-06 | ○ |
| C-05 | DecodeImage/DecodeJpegでchannels属性が0の場合、画像固有のチャネル数を使用 | E-04 | ○ |
| C-06 | NMSのboxes入力はrank=2で2番目の次元が4 | E-07 | ○ |
| C-07 | RandomCropはバージョン8で非推奨 | E-01(437行目) | ○ |
| C-08 | AdjustContrastはバージョン2で非推奨 | E-01(569行目) | ○ |
| C-09 | 画像分類画面・物体検出画面・スタイル変換画面で主機能として使用 | E-08 | ○ |
| C-10 | EncodeJpegは品質・プログレッシブ等の属性を持つ | E-01(528-540行目) | ○ |
| C-11 | CropAndResizeはbilinearとnearestの2つのmethod属性を持つ | E-01(919-948行目) | ○ |
| C-12 | ImageProjectiveTransformV3はfill_value入力を追加 | E-01(1207-1221行目) | ○ |
| C-13 | DrawBoundingBoxesV2はcolors入力を追加 | E-01(724-732行目) | ○ |
| C-14 | image_ops.ccは約40以上のオペレーションを定義 | E-01 | ○ |
| C-15 | リアルタイムカメラ処理では30FPS以上が求められる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: 30FPSの数値はカメラアプリケーションの一般的な要件に基づく推測であり、TensorFlowの公式要件として定義されたものではない。
  - 候補：Androidカメラアプリのベンチマーク結果 / TFLiteサンプルアプリのREADME / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Op定義の構造・入出力仕様はソースコードから正確に読み取れる
- 1: 中リスク - カーネル実装の詳細（補間アルゴリズムの精度等）は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] リサイズ系4種（Area, Bicubic, Bilinear, NearestNeighbor）の入出力型が正しいか確認
- [ ] デコード系Op（7種）の対応フォーマットが網羅されているか確認
- [ ] NMS V1〜V5の入出力パラメータの差異が正しく記載されているか確認
- [ ] 画面機能マッピングの関連画面が正しいか確認
